unit RunOptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TRunOptions = record
    NormalRun: Boolean;
    RepeatDrivers: Boolean;
    RepeatDriveTime: Integer;
    ResetStates: Boolean;
    ResetStateTime: Integer;
    RuntoSS: Boolean;
    Outputstep: double;
    Outputoffset: double;
    OutputEORonly: Boolean;
    OutputAppendFile: Boolean;
  end;
  TFmRunOptions = class(TForm)
    BtnCancel: TButton;
    GbRunType: TGroupBox;
    RbNormalRun: TRadioButton;
    RbSpecial: TRadioButton;
    CbRepeatDrivers: TCheckBox;
    EdRepeatDriveTime: TEdit;
    LblTimeUnit1: TLabel;
    CbResetStates: TCheckBox;
    LblTimeUnit2: TLabel;
    MmInfo: TMemo;
    GbOutputOptions: TGroupBox;
    RbOutputTimeStep: TRadioButton;
    RbOutEndofRunOnly: TRadioButton;
    EdOutputTimeStep: TEdit;
    LblTimeUnit3: TLabel;
    CbAppendOutput: TCheckBox;
    BtnOK: TButton;
    EdOutputOffset: TEdit;
    EdResetStateTime: TEdit;
    CbRuntoSS: TCheckBox;
    procedure FormCreate(Sender: TObject);
//    procedure GbRunTypeClick(Sender: TObject);
    procedure CbRepeatDriversClick(Sender: TObject);
    procedure CbResetStatesClick(Sender: TObject);
    procedure EdRepeatDriveTimeExit(Sender: TObject);
    procedure EdResetStateTimeExit(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure EdRepeatDriveTimeChange(Sender: TObject);
    procedure EdResetStateTimeChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UpdateFmRunOptions(Sender: TObject);
    procedure RbNormalRunClick(Sender: TObject);
    procedure RbSpecialClick(Sender: TObject);
  private
    { Private declarations }
    fDefaultRunOptions: TRunOptions;
  public
    { Public declarations }
    RunOptions: TRunOptions;
  end;

var
  FmRunOptions: TFmRunOptions;

implementation

{$R *.DFM}

uses frontend;

procedure TFmRunOptions.FormCreate(Sender: TObject);
begin
 LblTimeUnit1.Caption := ModelDef.timeunit;
 LblTimeUnit2.Caption := ModelDef.timeunit;
 LblTimeUnit3.Caption := ModelDef.timeunit;
 with RunOptions do
  begin
    NormalRun := True;
    RepeatDrivers := False;
    RepeatDriveTime := 0;
    ResetStates := False;
    ResetStateTime := 0;
    RuntoSS := False;
    Outputstep := 1;
    Outputoffset := 0;
    OutputEORonly := False;
    OutputAppendFile :False;
  end;
 fDefaultRunOptions := RunOptions;
end;


procedure TFmRunOptions.CbRepeatDriversClick(Sender: TObject);
begin
  if CbRepeatDrivers.Checked then
    begin
       RunOptions. := True;
    end
  else
    begin
       MainForm.RunXRepeatedly := False;
    end;
end;

procedure TFmRunOptions.CbResetStatesClick(Sender: TObject);
begin
  if CbResetStates.Checked then
    begin
       MainForm.ResetStates := True;
    end
  else
    begin
       MainForm.ResetStates := False;
    end;
end;

procedure TFmRunOptions.EdRepeatDriveTimeExit(Sender: TObject);
begin
try
 if EdRepeatDriveTime.Text <> '' then
   MainForm.RepeatDriveTime := strtoint(EdRepeatDriveTime.Text);
except
 MessageDlg('Invalid driver repeat time. Run set to Normal run.', mtwarning,
      [mbOK], 0);
 MainForm.MINormalRunClick(FmRunOptions);
 FmRunOptions.FormShow(FmRunOptions);
end;
end;

procedure TFmRunOptions.EdResetStateTimeExit(Sender: TObject);
begin
try
 if EdResetStateTime.Text <> '' then
   MainForm.ResetStateTime := strtoint(EdResetStateTime.Text);
except
 MessageDlg('Invalid state variable reset time. Run set to Normal run.',
      mtwarning, [mbOK], 0);
 MainForm.MINormalRunClick(FmRunOptions);
 FmRunOptions.FormShow(FmRunOptions);
end;
end;

procedure TFmRunOptions.BtnCancelClick(Sender: TObject);
begin
  if MainForm.RunXRepeatedly or MainForm.ResetStates then
    MainForm.MISpecialRun.Checked := True
  else
    MainForm.MINormalRun.Checked := True;
  FmRunOptions.Close;
end;

procedure TFmRunOptions.EdRepeatDriveTimeChange(Sender: TObject);
begin
  CbRepeatDrivers.Checked := True;
  CbRepeatDriversClick(EdRepeatDriveTime);
end;

procedure TFmRunOptions.EdResetStateTimeChange(Sender: TObject);
begin
  CbResetStates.Checked := True;
  CbResetStatesClick(EdResetStateTime);
end;

procedure TFmRunOptions.FormShow(Sender: TObject);
begin
 UpdateFmRunOptions(Sender);
end;

procedure TFmRunOptions.UpdateFmRunOptions(Sender: TObject);
begin
 if RunOptions.NormalRun then
   begin
     RbNormalRun.Checked := True;
     CbRepeatDrivers.Enabled := False;
     CbRepeatDrivers.Checked := False;
     EdRepeatDriveTime.Enabled := False;
     EdRepeatDriveTime.Text := '';
     CbResetStates.Enabled := False;
     CbResetStates.Checked := False;
     EdResetStateTime.Enabled := False;
     EdResetStateTime.Text := '';
     CbRuntoSS.Enabled := False;
     CbRuntoSS.Checked := False;
   end
 else // Special Run
   begin
     RbSpecialRun.Checked := True;
     CbRepeatDrivers.Enabled := True;
     EdRepeatDriveTime.Enabled := True;
     CbResetStates.Enabled := True;
     EdResetStateTime.Enabled := True;
     CbRuntoSS.Enabled := False;
     if RunOptions.RepeatDrivers then
      begin
       CbRepeatDrivers.Checked := True;
       EdRepeatDriveTime.Text := inttostr(RunOptions.RepeatDriveTime);
      end;
     if RunOptions.ResetStates then
      begin
       CbResetStates.Checked := True;
       EdResetStateTime.Text := inttostr(RunOptions.ResetStateTime);
      end;
     if RunOptions.RuntoSS then CbRuntoSS.Checked := True;
   end;
 if RunOptions.OutputEORonly then
   begin
     RbOutputEndofRunOnly.Checked := True;
     EdOutputTimeStep.Text := '';
     EdOutputTimeStep.Enabled := False;
     EdOutputOffset.Text := '';
     EdOutputOffset.Enabled := False;
   end
 else
   begin
     RbOutputTimeStep.Checked := True;
     EdOutputTimeStep.Text := floattostr(RunOptions.Outputstep);
     EdOutputTimeStep.Enabled := True;
     EdOutputOffset.Text := floattostr(RunOptions.Outputoffset);
     EdOutputOffset.Enabled := True;
   end;
 if RunOptions.OutputAppendFile then
   CbAppendOutput.Checked := True;
end;

procedure TFmRunOptions.RbNormalRunClick(Sender: TObject);
begin
 RunOptions.NormalRun := True;
 UpdateFmRunOptions(Sender);
end;

procedure TFmRunOptions.RbSpecialClick(Sender: TObject);
begin
 RunOptions.NormalRun := False;
 UpdateFmRunOptions(Sender);
end;

end.

